import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/data/controller/withdraw/add_withdraw_method_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_close_button.dart';

class AddWithdrawCurrencyBottomSheet extends StatelessWidget {
  const AddWithdrawCurrencyBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddWithdrawMethodController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Align(
            alignment: Alignment.topCenter,
            child: Container(
              height: 5,
              width: 50,
              padding: const EdgeInsets.all(1),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: MyColor.colorGrey.withOpacity(0.1),
              ),
            ),
          ),
          const Row(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [BottomSheetCloseButton()],
          ),
      
        ],
      ),
    );
  }
}
